/* Runge-Kutta-Fehlberg-Simo 78 bundle
 * Version 3, November, 2024.
 * Implemented by Lluis Alseda */

#include <math.h>
#include <values.h>

#define ABS(x)   ((x) < 0.0 ? -(x) : (x))
#define MIN(x,y) ((x) < (y) ? (x) : (y))
#define MAX(a,b) ((a) > (b) ? (a) : (b))

#ifndef _RKF_78_H_
#define _RKF_78_H_ 1

double RKF78_1step (double, double *, double, void *, void (*)(double, double, double *, void *));
int RKF78_forward  (double *, double *, double *, double *, double, double, double, void *, void (*)(double, double, double *, void *));
int RKF78_backward (double *, double *, double *, double *, double, double, double, void *, void (*)(double, double, double *, void *));

double RKF78_VF_1step (double, double [], unsigned, double, void *, void (*)(double,  double *, unsigned,  double *, void *));
int RKF78_VF_forward  (double *, double [], unsigned, double *, double *, double, double, double, void *, void (*)(double,  double *, unsigned,  double *, void *));
int RKF78_VF_backward (double *, double [], unsigned, double *, double *, double, double, double, void *, void (*)(double,  double *, unsigned,  double *, void *));

double eighthroot (double);

#endif
