#include <stdio.h>
#include <stdlib.h>
#include "RKF78.h"


typedef struct { double e; } ODE_Parameters;

const double time_f = 10.0;
void kamp(double t, double x, double *der, void *Params){ *der = (((ODE_Parameters *) Params)->e)*x*(1 - x); }

#define HMAX 0.1
#define HMIN 0.00001

int main()
{ double t = .0;
  double h=HMIN, hmax= HMAX, hmin= HMIN, err;
  double tol = 1e-15; //tolerancia:error que tolerem
  double x = 0.5;
  ODE_Parameters ODEPars = { 1.0 };


  printf("%2.15lf %20.15lf\n", t, x);
  do {
    RKF78_forward(&t, &x, &h, &err, hmin, hmax, tol, &ODEPars, kamp);
	printf("%2.15lf %20.15lf\n",t,x);
  } while(t < time_f);

  return(0);
}
