# This procs removes all accents of the input string (and transforms
# accented input char to lowercase:
# E.g. transforms   
#       "llebrd, pt, CACHAA, prevlling"    into  
#       "ollebrod, pate, CACHAcA, paerevaelling"
# (This is deliberately ignorant: even though  should really be
# transcribed into oe, and  into ij, a typical English dictionary
# will ignore this fact...)
proc removeAccentsEnglish { chunk } {
  regsub -all {[ˉ̌]} $chunk {a} chunk
  regsub -all {[]} $chunk {c} chunk
  regsub -all {[]} $chunk {e} chunk
  regsub -all {[]} $chunk {i} chunk
  regsub -all {[]} $chunk {n} chunk
  regsub -all {[Ϳ]} $chunk {o} chunk
#   regsub -all {[$]} $chunk {s} chunk
#   regsub -all {[]} $chunk {l} chunk
#   regsub -all {[&]} $chunk {and} chunk
  regsub -all {[]} $chunk {u} chunk
  regsub -all {[]} $chunk {y} chunk
  regsub -all {[]} $chunk {ae} chunk
  regsub -all {[]} $chunk {oe} chunk
  return $chunk
}

# This proc takes the first word of the input string
# strips all accents,
# removes all non-alpha letters,
# and transforms to lowercase...
proc Dict::fallback::normalForm { ord } {
  regexp {[^ ]+} $ord ord ; # takes the first word only
  set ord [removeAccentsEnglish $ord]
  regsub -all {[^A-Za-z]} $ord {} ord
  return [string tolower $ord]
}



# To format the output, before writing it to the console:
# This one is very simple: break the text into lines (according
# to global variables leftFillColumn' and 'fillColumn'); then
# insert a couple of spaces at the beginning of each line...
proc Dict::fallback::formatVerbet { linje } {
	#next line is an attempt to do some formating
  set linje [breakIntoLines $linje]
 	regsub -all \r $linje "\r  " linje
	return $linje
}
