#####################################################
#   This proc is for putting a string in normal form
#   It is used for the dictionary MSC2000
#####################################################

#   regsub -all {[ˉ]} $chunk {a} chunk
#   regsub -all {[]} $chunk {c} chunk
#   regsub -all {[]} $chunk {e} chunk
#   regsub -all {[]} $chunk {i} chunk
#   regsub -all {[]} $chunk {n} chunk
#   regsub -all {[]} $chunk {o} chunk
#   regsub -all {[]} $chunk {u} chunk
#   regsub -all {[]} $chunk {y} chunk
#   regsub -all {[]} $chunk {} chunk
#   regsub -all {[]} $chunk {} chunk
#   regsub -all {[wW]} $chunk {v} chunk ; # stupid feature of tbooks da-en: w=v
#   regsub -all {[]} $chunk {} chunk ; # I can't find a better replacement...
#   regsub -all {[]} $chunk {y} chunk ; # because of the word "Mnchen"
#   regsub -all {[]} $chunk {oe} chunk
#   return $chunk
# }


# This proc takes the first word of the input string
# strips all accents,
# and then removes all non-alpha letters
proc Dict::msc::normalForm { ord } {
#   regsub {^I\. } $ord {} ord
  regexp {[^ ]+} $ord ord
#   set ord [removeAccentsDanish $ord]
#   regsub {\(.+\)} $ord {} ord ; # necessary to catch "automobil(for)handler"
  regsub -all {[^-A-Za-z0-9\+]} $ord {} ord
  return [string toupper $ord]  ; # tolower doesn't touch 
}

proc Dict::msc::formatVerbet { linje } {
  set linje [breakIntoLines $linje]
	regsub -all \r $linje "\r        " linje
	return $linje
}
